/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.item.ItemEntityAssetsByItemType;
import technology.rocketjump.undermount.assets.entities.item.model.ItemEntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;

public class ItemEntityAssetsByAssetType {
    private final ItemTypeDictionary itemTypeDictionary;
    private Map<EntityAssetType, ItemEntityAssetsByItemType> typeMap = new HashMap<EntityAssetType, ItemEntityAssetsByItemType>();

    public ItemEntityAssetsByAssetType(EntityAssetTypeDictionary typeDictionary, ItemTypeDictionary itemTypeDictionary) {
        this.itemTypeDictionary = itemTypeDictionary;
        for (EntityAssetType assetType : typeDictionary.getByEntityType(EntityType.ITEM)) {
            this.typeMap.put(assetType, new ItemEntityAssetsByItemType(itemTypeDictionary));
        }
        this.typeMap.put(EntityAssetType.NULL_ENTITY_ASSET_TYPE, new ItemEntityAssetsByItemType(itemTypeDictionary));
    }

    public void add(ItemEntityAsset asset) {
        if (!this.typeMap.containsKey(asset.getType())) {
            throw new RuntimeException("Unrecognised asset type " + asset.getType() + " for " + asset.getUniqueName());
        }
        if (asset.getItemTypeNames() != null && !asset.getItemTypeNames().isEmpty()) {
            for (String itemTypeName : asset.getItemTypeNames()) {
                this.typeMap.get(asset.getType()).add(this.itemTypeDictionary.getByName(itemTypeName), asset);
                this.typeMap.get(EntityAssetType.NULL_ENTITY_ASSET_TYPE).add(this.itemTypeDictionary.getByName(itemTypeName), asset);
            }
        } else {
            this.typeMap.get(asset.getType()).add(this.itemTypeDictionary.getByName(asset.getItemTypeName()), asset);
            this.typeMap.get(EntityAssetType.NULL_ENTITY_ASSET_TYPE).add(this.itemTypeDictionary.getByName(asset.getItemTypeName()), asset);
        }
    }

    public ItemEntityAsset get(EntityAssetType entityAssetType, ItemEntityAttributes attributes) {
        if (entityAssetType == null) {
            entityAssetType = EntityAssetType.NULL_ENTITY_ASSET_TYPE;
        }
        return this.typeMap.get(entityAssetType).get(attributes);
    }

    public List<ItemEntityAsset> getAll(EntityAssetType entityAssetType, ItemEntityAttributes attributes) {
        return this.typeMap.get(entityAssetType).getAll(attributes);
    }
}

